! Writes current time <t> and calculates and writes <pressureEarCanal>
! to pressure ear canal file (each call writes one row of data)
! If <storeBinary>, the values will be written as real(4)'s in a binary file.
! To process the binary data in Matlab use:
! fid = fopen ( '    pressure ear canal file name    ' ) 
! x = fread(fid, [2, inf], 'real*4')
! t = x(1, :)
! pressureEarCanal = x(2, :)
! Call only iff:
!	IF (storePressureEarCanal) THEN

SUBROUTINE WritePressureEarCanal
	USE Declare
	USE FilesModule
	IMPLICIT NONE
	INTEGER ios
	REAL pressureEarCanal

	! Calculation of the pressure at the ear drum (ear canal)
!	IF (storePressureEarCanal) THEN
		pressureEarCanal = REAL(q0_factor * q(0) + g0_factor * (p0x * F0 + g(0) + r_Xtr0 * Y(0)) - Y0_factor * Y(0))
		IF (storeBinary) THEN
			WRITE (FH_pEarcan, IOSTAT = ios) REAL(t), pressureEarCanal
		ELSE
			WRITE (FH_pEarcan, '(ES15.7, ES26.7)', IOSTAT = ios) t, pressureEarCanal
		ENDIF
!	ENDIF

END SUBROUTINE WritePressureEarCanal